
public BloodSpurt(any:client)
{
	if(IsPlayer(client) == false) PrintToServer("[SM][DC] BloodSpurt:FALSE");
	
	decl Roll;
	decl Float:ClientOrigin[3];
	
	GetClientAbsOrigin(client, ClientOrigin);
	ClientOrigin[0] += 5.0;
	ClientOrigin[2] += 45.0;

	// Spray
	Roll = GetRandomInt(1, 6);
	if(Roll == 1) AttachPlayerParticle(client, "blood_advisor_pierce_spray");
	if(Roll == 2) AttachPlayerParticle(client, "blood_advisor_pierce_spray_b");
	if(Roll == 3) AttachPlayerParticle(client, "blood_advisor_pierce_spray_c");
	if(Roll == 4) AttachPlayerParticle(client, "blood_zombie_split_spray");
	if(Roll == 5) AttachPlayerParticle(client, "blood_zombie_split_spray_tiny");
	if(Roll == 6) AttachPlayerParticle(client, "blood_zombie_split_spray_tiny2");
	
	// Bleed
	Roll = GetRandomInt(1, 2);
	if(Roll == 1) NeckBleed(client);

	EmitSoundToAll(g_SpurtSound, client, SNDCHAN_AUTO, SNDLEVEL_NORMAL, SND_NOFLAGS, 0.5, SNDPITCH_NORMAL, -1, ClientOrigin, NULL_VECTOR, true, 0.0);
}

AttachPlayerParticle(any:client, String:particleType[], bool:death = false)
{
	if(IsPlayer(client) == false) PrintToServer("[SM][DC] AttachPlayerParticle:FALSE");
	new particle = CreateEntityByName("info_particle_system");	
	new String:tName[128];
	
	if (IsValidEdict(particle))
	{
		decl Float:position[3];
		
		GetEntPropVector(client, Prop_Send, "m_vecOrigin", position);

		TeleportEntity(particle, position, NULL_VECTOR, NULL_VECTOR);
		
		Format(tName, sizeof(tName), "Entity%d", client);
		DispatchKeyValue(client, "targetname", tName);
		GetEntPropString(client, Prop_Data, "m_iName", tName, sizeof(tName));
		
		DispatchKeyValue(particle, "targetname", "CSSparticle");
		DispatchKeyValue(particle, "parentname", tName);
		DispatchKeyValue(particle, "effect_name", particleType);
		
		DispatchSpawn(particle);
		
		if(death)
		{
			decl Body;
			decl String:classname[64];

			Body = GetEntPropEnt(client, Prop_Send, "m_hRagdoll");

			if(IsValidEdict(Body))
			{
				Format(tName, sizeof(tName), "Body%d", Body);

				GetEdictClassname(Body, classname, sizeof(classname));

				if(IsValidEntity(Body) && StrEqual(classname, "cs_ragdoll", false))
				{
					DispatchKeyValue(Body, "targetname", tName);
					GetEntPropString(Body, Prop_Data, "m_iName", tName, sizeof(tName));
				}
			}
		}

		SetVariantString(tName);
		AcceptEntityInput(particle, "SetParent", particle, particle, 0);
		
		SetVariantString("head");
		AcceptEntityInput(particle, "SetParentAttachment", particle, particle, 0);
		
		ActivateEntity(particle);
		AcceptEntityInput(particle, "start");
		
		g_ParticleEnt[client] = particle;
		
		CreateTimer(3.0, DeleteParticle, particle);
	}
}

public NeckBleed(any:client)
{
	if(IsPlayer(client) == false) PrintToServer("[SM][DC] NeckBleed:FALSE");
	decl Float:clientAngles[3];
	decl Float:direction[3];
	decl blood;
	decl String:angles[128];
	
	GetClientAbsAngles(client,clientAngles);

	direction[0] = Cosine(DegToRad(clientAngles[1]));
	direction[1] = Sine(DegToRad(clientAngles[1]));
	direction[2] = GetRandomFloat(-1.0, -0.5);

	Format(angles, 128, "%f %f %f", direction[0], direction[1], direction[2]);

	blood = CreateEntityByName("env_blood");

	if(IsValidEdict(blood))
	{
		DispatchSpawn(blood);

		DispatchKeyValue(blood, "color", "0");
		DispatchKeyValue(blood, "amount", "1000");
		DispatchKeyValue(blood, "spraydir", angles);
		DispatchKeyValue(blood, "spawnflags", "12");

		AcceptEntityInput(blood, "EmitBlood", client);
		RemoveEdict(blood);
	}
}

public Action:SpoutSpurt(Handle:timer)
{
	AttachChippyParticle(g_ChippyEnt, "spout", "blood_advisor_puncture_withdraw");
}

public Action:HopperSpurt()
{
	AttachChippyParticle(g_ChippyEnt, "hopper", "blood_advisor_puncture");
}

public AttachChippyParticle(any:client, String:attachPoint[], String:particleType[])
{
	new particle = CreateEntityByName("info_particle_system");
	
	new String:tName[128];
	
	if (IsValidEdict(particle))
	{
		decl Float:position[3];
		
		GetEntPropVector(client, Prop_Send, "m_vecOrigin", position);

		TeleportEntity(particle, position, NULL_VECTOR, NULL_VECTOR);
		
		Format(tName, sizeof(tName), "Entity%d", client);
		DispatchKeyValue(client, "targetname", tName);
		GetEntPropString(client, Prop_Data, "m_iName", tName, sizeof(tName));
		
		DispatchKeyValue(particle, "targetname", "CSSparticle");
		DispatchKeyValue(particle, "parentname", tName);
		DispatchKeyValue(particle, "effect_name", particleType);
		
		DispatchSpawn(particle);

		SetVariantString(tName);
		AcceptEntityInput(particle, "SetParent", particle, particle, 0);
		
		SetVariantString(attachPoint);
		AcceptEntityInput(particle, "SetParentAttachment", particle, particle, 0);
		
		ActivateEntity(particle);
		AcceptEntityInput(particle, "start");
		
		CreateTimer(3.0, DeleteParticle, particle);
	}
}

public Action:DeleteParticle(Handle:Timer, any:particle)
{
    if (IsValidEntity(particle))
    {
        new String:classname[256];
        GetEdictClassname(particle, classname, sizeof(classname));
        if (StrEqual(classname, "info_particle_system", false))
        {
            RemoveEdict(particle);
        }
    }
}